export function sleep(ms: number): Promise<unknown> {
  return new Promise(resolve => setTimeout(resolve, ms));
}

export async function minDelay<T>(promise: Promise<T>, ms: number): Promise<T> {
  const [p] = await Promise.all([promise, sleep(ms)])
  return p;
}

const INTERNAL__executeCheckDivisions = 5 as const;
const INTERNAL__wasCancelledResponse = { message: 'Task was cancelled' } as const
type asdf = typeof INTERNAL__wasCancelledResponse
export async function executeOrReject<T>(promise: () => Promise<T>, ms: number, token?: { cancelled: boolean }, executionDivision = INTERNAL__executeCheckDivisions): Promise<T | asdf> {
  if (!token || token.cancelled) {
    return promise()
  }

  if (ms < 5000) {
    await sleep(ms)
    if (token.cancelled) {
      return INTERNAL__wasCancelledResponse
    }

    return promise()
  }

  const waitTime = ms / executionDivision
  for (let i = 0; i < executionDivision; i++) {
    await sleep(waitTime);
    if (token.cancelled) {
      return INTERNAL__wasCancelledResponse;
    }
  }

  return promise()
}
